﻿(function ($) {
    var autoCompleteSharedData = [];

    $.widget("a4.a4newautocomplete", {
        options: {
            ajaxAction: undefined,
            ajaxParams: {},
            ajaxInitialData: null,
            ajaxExcludeData: null,
            data: undefined,
            valueProperty: "Value",
            labelProperty: "Label",
            descriptionProperty: "Desc",
            categoryProperty: undefined,
            tooltipProperty: undefined,
            tooltipData: undefined,
            sortData: false,
            validateSelection: true,
            multipleSelection: false,
            displayMultipleSelectionAsList: false,
            resources: [],
            valueSeparator: ",",
            displaySeparator: null,
            displayDeleteItem: false,
            limitResults: 100,
            altValueField: undefined, //Input element that is to be updated with the selected value from the autocomplete.
            appendToParent: true, //For use inside modal dialogs (Doesn't work with IE)
            hideSelectedItems: false, //Hide selected items in suggestion box
            required: false, //Auto select item if there's only 1 item in the list
            render: {
                item: undefined,
                selected: undefined
            },
            boxWidth: undefined
        },
        _create: function () {
            var self = this;
            var autocomplete = this.element;

            // Wrap autocomplete with a div, if it's not done yet
            if (autocomplete.closest(".autocomplete-container").length == 0) {
                autocomplete.wrap("<div class='autocomplete-container'></div>");
            }

            this.wrapper = autocomplete.closest(".autocomplete-container");

            var source = this._getSource();

            if (source) {
                if (this.options.sortData) {
                    //Set sort field
                }

                var selectedText = this.element.val();
                var selectedItems = this.element.attr("data-value");

                if (!selectedItems && this.options.altValueField)
                    selectedItems = this.options.altValueField.val();

                autocomplete.selectize({
                    items: selectedItems,
                    preload: "focus",
                    persist: false,
                    create: !this.options.validateSelection,
                    maxOptions: this.options.limitResults,
                    maxItems: this.options.multipleSelection ? null : 1,
                    valueField: this.options.valueProperty,
                    labelField: this.options.labelProperty,
                    optgroupField: this.options.categoryProperty,
                    searchField: [this.options.labelProperty, this.options.descriptionProperty, this.options.categoryProperty],
                    load: source,
                    placeholder: this._getLabel("PlaceHolder"),
                    hideSelected: this.options.hideSelectedItems,
                    dropdownParent: "body",
                    scrollDuration: 0,
                    loadThrottle: null,
                    openOnFocus: true,
                    onInitialize: function () {                        
                    },
                    onChange: function (value) {
                        if (self.options.altValueField)
                            self.options.altValueField.val(value);

                        self._trigger("select", null, { item: self._getItemByValue(value, self._getData()) });
                    }
                });
                
                autocomplete.selectize("setTextboxValue", selectedText);

                /*
                autocomplete.autocomplete({
                    source: source,
                    minLength: 1,
                    delay: 100,
                    change: function (event, ui) {
                        if (!self.preventSelect) {
                            self._selectItem(ui);
                        }
                    },
                    select: function (event, ui) {
                        self.preventSelect = true;
                        self._selectItem(ui);
                        autocomplete.trigger("change");
    
                        if (event)
                            event.preventDefault();
                    },
                    open: function () {
                        autocomplete.addClass("autocomplete-open");
                        self.isOpen = true;
                    },
                    close: function () {
                        //IE focus hack
                        autocomplete.autocomplete("option", "minLength", 1);
                        autocomplete.removeClass("autocomplete-open");
                        self.isOpen = false;
                        self._hideTooltip();
                    },
                    search: function (event, ui) {
                        self._trigger("search", event, {});
                    }
                }).blur(function () {
                    self.preventSelect = false;
                    self._hideTooltip();
                });
                */

                //this._resolveInitialValue();

                //this._initializeTooltip();
            }

            //Set autocomplete to disabled if input is disabled
            //if (this.element.is(":disabled")) {
            //    $(".h-autocomplete-button", this.wrapper).addClass("disabled");

            //    if (this.options.multipleSelection) {
            //        $(".selected-item", this.wrapper).addClass("disabled");
            //        $(".selected-item .remove-item", this.wrapper).addClass("disabled");
            //    }
            //}

            this._trigger("create");
        },
        _getSource: function () {
            var self = this;
            var data = this.options.data;
            var ajaxAction = this.options.ajaxAction;
            var ajaxParams = this.options.ajaxParams;
            var ajaxInitialData = this.options.ajaxInitialData;
            var ajaxExcludeData = this.options.ajaxExcludeData;
            var source;

            if (data) {
                source = function (query, callback) {
                    callback(data);
                }
            }
            else if (ajaxAction) {
                var dataKey = ajaxAction.replace(/\//g, "_") + _.values(ajaxParams).join("_");
                this.dataKey = dataKey;

                source = function (query, callback) {
                    if (!autoCompleteSharedData[self.dataKey]) {
                        a4.callServerMethod(ajaxAction, ajaxParams, function (result) {
                            if (result && ajaxInitialData) {
                                result.unshift(ajaxInitialData);
                            }

                            if (result && ajaxExcludeData) {
                                result = _.reject(result, function (r) { return _.contains(ajaxExcludeData, r.Value); });
                            }

                            if (result && result.length > 0) {
                                autoCompleteSharedData[self.dataKey] = result;
                                callback(autoCompleteSharedData[self.dataKey]);
                            }
                            else {
                                autoCompleteSharedData[self.dataKey] = {};
                                callback(null);
                            }
                        }, function (error) {
                            autoCompleteSharedData[self.dataKey] = {};
                            callback(null);
                        });
                    }
                    else {
                        callback(autoCompleteSharedData[self.dataKey]);
                    }
                }
            }

            return source;
        },
        _initializeTooltip: function () {
            var autocomplete = this.element;
            var options = this.options;
            var data = $.isFunction(options.data) ? options.data() : options.data;
            if (!options.ajaxAction && autocomplete.attr("data-value")) {
                var item = _.find(data, function (e) { return e[options.valueProperty] == autocomplete.attr("data-value"); });

                if (item) {
                    if (options.tooltipData != null && _.isFunction(options.tooltipData)) {
                        options.tooltipData(autocomplete, null, item[options.tooltipProperty]);
                    }
                    else if (options.tooltipProperty != null) {
                        autocomplete.attr("title", item[options.tooltipProperty]);
                    }
                }
            }
        },
        _renderTooltip: function (item) {
            var autocomplete = this.element;
            var menu = autocomplete.autocomplete("widget");
            var options = this.options;
            var tooltip = this.tooltip;

            if (!tooltip) {
                tooltip = $("<div />", { "class": "autocomplete-tooltip ui-front" });

                menu.parent().append(tooltip);

                this.tooltip = tooltip;
            }

            tooltip.show();

            tooltip.position({
                my: "left top",
                at: "right top",
                of: menu,
                collision: "none"
            });

            this._hideTooltip();

            if (options.tooltipData && _.isFunction(options.tooltipData)) {
                this.tooltipTimer = window.setTimeout(function () {
                    var data = (options.tooltipProperty ? item[options.tooltipProperty] : item);
                    options.tooltipData(autocomplete, tooltip, data);
                }, 500);
            }
            else if (options.tooltipProperty && item[options.tooltipProperty]) {
                this.tooltipTimer = window.setTimeout(function () {
                    tooltip.html(item[options.tooltipProperty]).show();
                }, 500);
            }
        },
        _hideTooltip: function () {
            if (this.tooltipTimer) {
                window.clearTimeout(this.tooltipTimer);
            }

            if (this.tooltip) {
                this.tooltip.hide();
            }
        },
        _setOption: function (key, value) {
            var options = this.options;
            this._super(key, value);

            switch (key) {
                case "data":
                    var source = this._getSource();
                    this.element.autocomplete("option", "source", source);
                    this._resolveInitialValue();
                    break;
                case "ajaxAction":
                case "ajaxParams":
                    var source = this._getSource();
                    this.element.autocomplete("option", "source", source);
                    //this.clearValue();
                    break;
            }
        },
        _resolveInitialValue: function () {
            var self = this;
            var dataValue = this.element.attr("data-value");

            if (!dataValue && this.options.altValueField)
                dataValue = this.options.altValueField.val();

            var numericValue = parseInt(dataValue);

            if (dataValue && dataValue.length > 0 && (isNaN(numericValue) || numericValue > 0) && this.element.val().length == 0) {
                if (this.options.multipleSelection) {
                    var data = this._getData();

                    var values = dataValue.split(this.options.valueSeparator);

                    _.each(values, function (v) {
                        var item = self._getItemByValue(v, data);
                        if (item) {
                            $(".selected-items", self.wrapper).append(self._getAutoCompleteItemForMultiple(item));
                        }
                    });

                    this._updateMultipleCount();
                }
                else {
                    var data = this._getData();

                    var item = this._getItemByValue(dataValue, data);

                    if (item)
                        this.element.val(item[this.options.labelProperty]);
                    else if (!this.element.val())
                        this.element.val(dataValue);
                }
            }
            else if (this.options.required) {
                var data = this._getData();

                if (data) {
                    var firstItem = _.first(data);

                    if (firstItem) {
                        if (this.options.multipleSelection) {
                            $(".selected-items", this.wrapper).append(this._getAutoCompleteItemForMultiple(firstItem));

                            this._updateMultipleCount();

                            this._updateAltValueFieldForMultiple();
                        }
                        else {
                            this.element.val(firstItem[this.options.labelProperty]);

                            if (this.options.altValueField) {
                                this.options.altValueField.val(firstItem[this.options.valueProperty]).change();
                            }
                        }
                    }
                }
            }
        },        
        _preloadData: function () {
            var self = this;
            var dataKey = this.dataKey;

            if (!autoCompleteSharedData[dataKey] && this.options.ajaxAction) {
                a4.callServerMethod(this.options.ajaxAction, this.options.ajaxParams, function (result) {
                    if (result && result.length > 0) {
                        autoCompleteSharedData[dataKey] = result;
                    }
                    else {
                        autoCompleteSharedData[dataKey] = {};
                    }
                }, function () {
                    autoCompleteSharedData[dataKey] = {};
                },
                { "async": false });
            }

            return autoCompleteSharedData[dataKey];
        },
        _getData: function () {
            var data;

            if (this.options.data) {
                data = $.isFunction(this.options.data) ? this.options.data() : this.options.data;
            }
            else {
                data = autoCompleteSharedData[this.dataKey];

                if (!data || data.length == 0) {
                    data = this._preloadData();
                }
            }

            return data;
        },
        _getItemByValue: function (value, data) {
            var item;
            var valueProperty = this.options.valueProperty;
            var labelProperty = this.options.labelProperty;

            if (data && data.length > 0) {
                item = _.find(data, function (i) { return i[valueProperty] == value });
            }
            else if (!this.options.validateSelection) {
                item = {};
                item[valueProperty] = value;
                item[labelProperty] = value;
            }

            return item;
        },
        _getLabel: function (key) {
            var text = undefined;

            if (this.options.resources[key]) {
                text = this.options.resources[key];
            }
            else if (autoCompleteResources && autoCompleteResources[key]) {
                text = autoCompleteResources[key];
            }

            return text;
        },
        _destroy: function () {
            $(".h-autocomplete-button", this.wrapper).remove();

            if (this.options.multipleSelection) {
                $(".selected-items", this.wrapper).remove();
            }

            if (!a4.ie() && this.options.appendToParent && this.element.closest(".modernEditor").length > 0 && a4.inIFrame(this.element)) {
                this.element.scrollParent().unbind("scroll");
            }

            this.element.unwrap().unwrap(); //Remove parent containers.
            this.element.removeClass("autocomplete");
            this.element.removeAttr("data-value");
            this.element.autocomplete("destroy");
        },
        clearValue: function () {
            this.element.removeAttr("data-value");

            if (this.options.multipleSelection) {
                $(".selected-item", this.wrapper).remove();
                this._updateMultipleCount();
                this._updateAltValueFieldForMultiple();
            }
            else {
                this.element.val("");

                if (this.options.altValueField)
                    this.options.altValueField.val("").change();
            }
        },
        getValue: function () {
            var data = this._getData();
            var valueProperty = this.options.valueProperty;

            if (this.options.multipleSelection) {
                var values = this.element.selectize("getValue").split(",");

                if (this.options.validateSelection) {
                    var items = [];

                    _.each(values, function (value) {
                        items.push(_.find(data, function (item) { return item[valueProperty] == value; }))
                    });

                    return items;
                }
                else {
                    return values;
                }
            }
            else {
                var value = this.element.selectize("getValue");

                if (!value && this.options.altValueField)
                    value = this.options.altValueField.val();

                if (this.options.validateSelection) {
                    return _.find(data, function (item) { return item[valueProperty] == value; }) || null;
                }
                else {
                    return value;
                }
            }
        },
        _isSelected: function (item) {
            var itemValue = item[this.options.valueProperty];

            if (this.options.multipleSelection) {
                return $(".selected-item[data-value='" + itemValue + "']", this.wrapper).length > 0;
            }
            else {
                return itemValue == this.element.attr("data-value");
            }
        },
        toggle: function (disabled) {
            this.element.autocomplete("option", "disabled", disabled);
            this.element.prop("disabled", disabled);
            $(".h-autocomplete-button", this.wrapper).toggleClass("disabled", disabled);

            if (this.options.multipleSelection) {
                $(".selected-item", this.wrapper).toggleClass("disabled", disabled);
                $(".selected-item .remove-item", this.wrapper).toggleClass("disabled", disabled);
            }
        },
        disable: function () {
            this.toggle(true);
        },
        enable: function () {
            this.toggle(false);
        },
        clearCache: function () {
            autoCompleteSharedData[this.dataKey] = undefined;
        },
        getSelectedItemsCount: function () {
            return this.options.multipleSelection ? $(".selected-items .selected-item", this.wrapper).length : 1;
        }
    });
}(jQuery));